<div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">{{ __('Add State') }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <form id="modalForm" class="modal-form create"
                    action="{{ route('admin.event_management.store_state') }}" method="post">
                    @csrf
                    <div class="form-group">
                        <label for="">{{ __('Language') . '*' }}</label>
                        <select name="language_id" class="form-control langWiseCountry">
                            <option selected disabled>{{ __('Select a Language') }}</option>
                            @foreach ($langs as $lang)
                                <option value="{{ $lang->id }}">{{ $lang->name }}</option>
                            @endforeach
                        </select>
                        <p id="err_language_id" class="mt-1 mb-0 text-danger em"></p>
                    </div>

                    @if ($settings->event_country_status == 1)
                        <div class="form-group">
                            <label for="">{{ __('Country') . '*' }}</label>
                            <select name="country_id" class="form-control select2 country_select">
                                <option selected disabled>{{ __('Select Country') }}</option>
                            </select>
                            <p id="err_country_id" class="mt-1 mb-0 text-danger em"></p>
                        </div>
                    @endif

                    <div class="form-group">
                        <label for="">{{ __('Name') . ' *' }}</label>
                        <input type="text" class="form-control" name="name" placeholder="Enter name">
                        <p id="err_name" class="mt-2 mb-0 text-danger em"></p>
                    </div>


                    <div class="form-group">
                        <label for="">{{ __('Status') . '*' }}</label>
                        <select name="status" class="form-control">
                            <option selected disabled>{{ __('Select a Status') }}</option>
                            <option value="1">{{ __('Active') }}</option>
                            <option value="0">{{ __('Deactive') }}</option>
                        </select>
                        <p id="err_status" class="mt-1 mb-0 text-danger em"></p>
                    </div>
                    <div class="form-group">
                        <label for="">{{ __('Serial Number') . ' *' }}</label>
                        <input type="text" class="form-control" name="serial_number"
                            placeholder="Enter serial number">
                        <p id="err_serial_number" class="mt-2 mb-0 text-danger em"></p>
                        <span
                            class="text-warning">{{ __('The higher the serial number is, the later the country will be shown.') }}</span>
                    </div>
                </form>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">
                    {{ __('Close') }}
                </button>
                <button id="modalSubmit" type="button" class="btn btn-primary btn-sm">
                    {{ __('Save') }}
                </button>
            </div>
        </div>
    </div>
</div>
